#include "meson-sample.h"

struct _MesonSample
{
  GObject parent_instance;

  gchar *msg;
};

G_DEFINE_TYPE (MesonSample, meson_sample, G_TYPE_OBJECT)

enum {
  PROP_0,
  PROP_MSG,
  LAST_PROP
};

static GParamSpec *gParamSpecs [LAST_PROP];

/**
 * meson_sample_new:
 *
 * Allocates a new #MesonSample.
 *
 * Returns: (transfer full): a #MesonSample.
 */
MesonSample *
meson_sample_new (void)
{
  return g_object_new (MESON_TYPE_SAMPLE, NULL);
}

static void
meson_sample_finalize (GObject *object)
{
  MesonSample *self = (MesonSample *)object;

  g_clear_pointer (&self->msg, g_free);

  G_OBJECT_CLASS (meson_sample_parent_class)->finalize (object);
}

static void
meson_sample_get_property (GObject    *object,
                           guint       prop_id,
                           GValue     *value,
                           GParamSpec *pspec)
{
  MesonSample *self = MESON_SAMPLE (object);

  switch (prop_id)
    {
    case PROP_MSG:
      g_value_set_string (value, self->msg);
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
meson_sample_set_property (GObject      *object,
                           guint         prop_id,
                           const GValue *value,
                           GParamSpec   *pspec)
{
  MesonSample *self = MESON_SAMPLE (object);

  switch (prop_id)
    {
    case PROP_MSG:
      self->msg = g_value_dup_string (value);
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
meson_sample_class_init (MesonSampleClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  object_class->finalize = meson_sample_finalize;
  object_class->get_property = meson_sample_get_property;
  object_class->set_property = meson_sample_set_property;

  gParamSpecs [PROP_MSG] =
    g_param_spec_string ("message",
                         "Message",
                         "The message to print.",
                         NULL,
                         (G_PARAM_READWRITE |
                          G_PARAM_CONSTRUCT_ONLY |
                          G_PARAM_STATIC_STRINGS));

  g_object_class_install_properties (object_class, LAST_PROP, gParamSpecs);
}

static void
meson_sample_init (MesonSample *self)
{
}

/**
 * meson_sample_print_message:
 * @self: a #MesonSample.
 *
 * Prints the message.
 *
 * Returns: Nothing.
 */
void
meson_sample_print_message (MesonSample *self, MesonDep1 *dep1, MesonDep2 *dep2)
{
  MesonDep2 *samedep;
  g_return_if_fail (MESON_IS_SAMPLE (self));

  samedep = meson_dep1_just_return_it (dep1, dep2);
  g_print ("Message: %s\n", meson_dep2_return_message (samedep));
}
